<div class="header">
    <?php
        $height = setting('site_logo_height','global') == 'auto' ? 'auto' : setting('site_logo_height','global').'px';
        $width = setting('site_logo_width','global') == 'auto' ? 'auto' : setting('site_logo_width','global').'px';
    ?>

    <div class="logo">
        <a href="<?php echo e(route('admin.dashboard')); ?>">
            <img
                class="logo-unfold"
                style="height:<?php echo e($height); ?>;width:<?php echo e($width); ?>"
                src="<?php echo e(asset(setting('site_logo','global'))); ?>"
                alt="<?php echo e(setting('site_title','global')); ?>"
            />
            <img
                class="logo-fold"
                src="<?php echo e(asset(setting('site_favicon','global'))); ?>"
                alt="<?php echo e(setting('site_title','global')); ?>"
            />
        </a>
    </div>
    <div class="nav-wrap">
        <div class="nav-left">
            <button class="sidebar-toggle"><i data-lucide="align-justify"></i></button>
        </div>
        <div class="nav-right">
            <?php if(setting('language_switcher')): ?>
            <div class="single-nav-right admin-language-switch">
                <select name="language" class="form-select"
                        onchange="window.location.href=this.options[this.selectedIndex].value;">
                    <?php $__currentLoopData = \App\Models\Language::where('status',true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option
                            value="<?php echo e(route('language-update',['name'=> $lang->locale])); ?>" <?php if( app()->getLocale() == $lang->locale ): echo 'selected'; endif; ?>><?php echo e($lang->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <?php endif; ?>
            <div class="single-nav-right admin-notifications">
                <?php
                    $notifications = App\Models\Notification::with('user')->where('for','admin')->latest()->take(10)->get();
                    $totalUnread = App\Models\Notification::with('user')->where('for','admin')->where('read', 0)->count();
                    $totalCount = App\Models\Notification::with('user')->where('for','admin')->get()->count();
                ?>
                <?php echo $__env->make('global.__notification_data',['notifications'=>$notifications,'totalUnread'=>$totalUnread,'totalCount'=>$totalCount], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>


            <div class="single-nav-right">
                <a href="<?php echo e(route('home')); ?>" target="_blank" class="item" data-bs-toggle="tooltip" title=""
                   data-bs-placement="left" data-bs-original-title="Visit Landing Page">
                    <i data-lucide="globe"></i>
                </a>
            </div>
            <div class="single-nav-right">
                <button type="button" class="item" data-bs-toggle="dropdown" aria-expanded="false">
                    <i data-lucide="user"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                        <a href="<?php echo e(route('admin.profile')); ?>" class="dropdown-item"><i
                                data-lucide="user"></i><?php echo e(__('Profile')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.password-change')); ?>" class="dropdown-item">
                            <i data-lucide="lock"></i><?php echo e(__('Change Password')); ?>

                        </a>
                    </li>
                    <li class="logout">

                        <a href="<?php echo e(url('admin/logout')); ?>" class="dropdown-item" type="button"
                           onclick="event.preventDefault(); localStorage.clear();  $('#logout-form').submit();">
                            <i data-lucide="log-out"></i> <?php echo e(__('Logout')); ?>

                        </a>
                        <form id="logout-form" action="<?php echo e(route('admin.logout')); ?>" method="POST" class="d-none">
                            <?php echo csrf_field(); ?>
                        </form>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php /**PATH F:\www\ptc20\resources\views/backend/include/__header.blade.php ENDPATH**/ ?>