
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Admin Login')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('auth-content'); ?>
    <div class="login">
        <div class="side-img primary-overlay" style="background: url(<?php echo e(asset(setting('login_bg','global'))); ?>) no-repeat center center;">
            <div class="title">
                <h3><?php echo e(__('Admin Login')); ?></h3>
            </div>
        </div>
        <div class="login-content">
            <div class="logo">
                <?php
                    $height = setting('site_logo_height','global') == 'auto' ? 'auto' : setting('site_logo_height','global').'px';
                    $width = setting('site_logo_width','global') == 'auto' ? 'auto' : setting('site_logo_width','global').'px';
                ?>
                <a href="<?php echo e(route('home')); ?>">
                    <img src="<?php echo e(asset(setting('site_logo','global') )); ?>" style="height:<?php echo e($height); ?>;width:<?php echo e($width); ?>" alt="<?php echo e(asset(setting('site_title','global') )); ?>"/>
                </a>
            </div>
            <div class="auth-body">

                <form action="<?php echo e(route('admin.login')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="single-box">
                        <label for="" class="box-label"><?php echo e(__('Admin Email')); ?></label>
                        <input
                            type="email"
                            name="email"
                            class="box-input"
                            required
                        />
                    </div>
                    <div class="single-box">
                        <label for="" class="box-label"><?php echo e(__('Password')); ?></label>
                        <input
                            type="password"
                            name="password"
                            class="box-input"
                        />
                    </div>
                    <div class="single-box">
                        <button class="site-btn primary-btn" type="submit"><?php echo e(__('Admin Login')); ?></button>
                        <a href="<?php echo e(route('admin.forget.password.now')); ?>"
                           class="link mt-2"><?php echo e(__('Forget Password?')); ?></a>
                    </div>
                </form>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.auth.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\www\ptc20\resources\views/backend/auth/login.blade.php ENDPATH**/ ?>