<?php use App\Enums\InvestStatus; ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Admin Dashboard')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(setting('site_title', 'global')); ?> <?php echo e(__('Dashboard')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">

            <div class="row">
                <?php echo $__env->make('backend.include.__action', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make('backend.include.__data_card', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('site-statistics-chart')): ?>
                <div class="col-xl-8 col-lg-8 col-md-8 col-sm-8">
                    <div class="site-chart">
                        <div class="site-card">
                            <div class="site-card-header">
                                <h3 class="title"><?php echo e(__('Site Statistics')); ?></h3>
                                <div class="card-header-links">
                                    <input class="card-header-input" type="text" name="site_daterange" value="<?php echo e($data['start_date'] .' - '. $data['end_date']); ?>" />
                                </div>
                            </div>
                            <div class="site-card-body">
                                <canvas id="statisticsChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('fund-transfer-statistics')): ?>
                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4">
                    <div class="site-chart">
                        <div class="site-card">
                            <div class="site-card-header">
                                <h3 class="title"><?php echo e(__('Fund Transfer Statistics')); ?></h3>
                            </div>
                            <div class="site-card-body">
                                <canvas id="fundTransferChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('top-country-statistics')): ?>
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="site-chart">
                        <div class="site-card">
                            <div class="site-card-header">
                                <h3 class="title"><?php echo e(__('Top Country Statistics')); ?></h3>
                            </div>
                            <div class="site-card-body">
                                <canvas id="countryChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('top-browser-statistics')): ?>
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="site-chart">
                        <div class="site-card">
                            <div class="site-card-header">
                                <h3 class="title"><?php echo e(__('Top Browser Statistics')); ?></h3>
                            </div>
                            <div class="site-card-body">
                                <canvas id="browserChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('top-os-statistics')): ?>
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="site-chart">
                        <div class="site-card">
                            <div class="site-card-header">
                                <h3 class="title"><?php echo e(__('Top OS Statistics')); ?></h3>
                            </div>
                            <div class="site-card-body">
                                <canvas id="osChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('latest-users')): ?>
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('Latest Users')); ?></h3>
                        </div>
                        <div class="site-card-body table-responsive">
                            <div class="site-datatable">
                                <table class="data-table mb-0">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(__('Avatar')); ?></th>
                                        <th><?php echo e(__('User')); ?></th>
                                        <th><?php echo e(__('Email')); ?></th>
                                        <th><?php echo e(__('Balance')); ?></th>
                                        <th><?php echo e(__('KYC')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $data['latest_user']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php echo $__env->make('backend.user.include.__avatar', ['avatar' => $user->avatar, 'first_name' => $user->first_name, 'last_name' => $user->last_name], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('admin.user.edit',$user->id)); ?>"
                                                   class="link"><?php echo e(Str::limit($user->username,15)); ?>

                                                </a>
                                            </td>
                                            <td>
                                                <strong><?php echo e(Str::limit($user->email,20)); ?></strong>
                                            </td>
                                            <td><strong><?php echo e($currencySymbol . $user->balance); ?></strong></td>
                                            <td>
                                                <?php if($user->kyc == 1): ?>
                                                    <div class="site-badge success"><?php echo e(__('Verified')); ?></div>
                                                <?php else: ?>
                                                    <div class="site-badge pending"><?php echo e(__('Unverified')); ?></div>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($user->status == 1): ?>
                                                    <div class="site-badge success"><?php echo e(__('Active')); ?></div>
                                                <?php else: ?>
                                                    <div class="site-badge danger"><?php echo e(__('DeActivated')); ?></div>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php echo $__env->make('backend.user.include.__action', ['user' => $user,'delete_hidden' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="centered">
                                        <td colspan="7">
                                            <?php if($data['latest_user']->isEmpty()): ?>
                                                <?php echo e(__('No Data Found')); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

            </div>

        </div>
    </div>
    <!-- Modal for Send Email -->
    <?php echo $__env->make('backend.user.include.__mail_send', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Send Email-->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php echo $__env->make('backend.include.__chartjs', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        (function ($) {
            'use strict'
            //send mail modal form open
            $('body').on('click', '.send-mail', function () {
                var id = $(this).data('id');
                var name = $(this).data('name');
                $('#name').html(name);
                $('#userId').val(id);
                $('#sendEmail').modal('toggle')
            })

            // Delete
            $('body').on('click', '#deleteModal', function () {
                var id = $(this).data('id');
                var name = $(this).data('name');

                $('#data-name').html(name);
                var url = '<?php echo e(route("admin.user.destroy", ":id")); ?>';
                url = url.replace(':id', id);
                $('#deleteForm').attr('action', url);
                $('#delete').modal('toggle')

            });
        })(jQuery)
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\www\ptc20\resources\views/backend/dashboard.blade.php ENDPATH**/ ?>