<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-users')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="users"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['register_user']); ?></h4>
            <p><?php echo e(__('Total Users')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.user.index')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('active-users')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="user-check"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['active_user']); ?></h4>
            <p><?php echo e(__('Active Users')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.user.active')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('disabled-users')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="user-round-x"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['disabled_user']); ?></h4>
            <p><?php echo e(__('Disabled Users')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.user.disabled')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-staff')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="user-cog"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['total_staff']); ?></h4>
            <p><?php echo e(__('Total Staff')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.staff.index')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-deposits')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="wallet"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_deposit']); ?></span></h4>
            <p><?php echo e(__('Total Deposits')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.deposit.history')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-ads')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="table-cells-split"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['total_ads']); ?></h4>
            <p><?php echo e(__('Total Ads')); ?></p> 
        </div>
        <a class="link" href="<?php echo e(route('admin.ads.index')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-ads-earnings')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="dollar-sign"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_ads_earnings']); ?></span> </h4>
            <p><?php echo e(__('Total Ads Earnings')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.transactions',['type' => 'ads_viewed'])); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-withdraw')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="landmark"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_withdraw']); ?></span></h4>
            <p><?php echo e(__('Total Withdraw')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.withdraw.history')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-referral')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="link"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['total_referral']); ?></h4>
            <p><?php echo e(__('Total Referral')); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-fund-transfer')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="send"></i>
        </div>
        <div class="content">
            <h4><?php echo e($currencySymbol); ?><span class="count"><?php echo e($data['total_send']); ?></span></h4>
            <p><?php echo e(__('Total Fund Transfer')); ?></p>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-automatic-gateway')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="webhook"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['total_gateway']); ?></h4>
            <p><?php echo e(__('Total Automatic Gateways')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.gateway.automatic')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('total-ticket')): ?>
<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
    <div class="data-card">
        <div class="icon">
            <i data-lucide="help-circle"></i>
        </div>
        <div class="content">
            <h4 class="count"><?php echo e($data['total_ticket']); ?></h4>
            <p><?php echo e(__('Total Ticket')); ?></p>
        </div>
        <a class="link" href="<?php echo e(route('admin.ticket.index')); ?>"><i data-lucide="external-link"></i></a>
    </div>
</div>
<?php endif; ?>
<?php /**PATH F:\www\ptc20\resources\views/backend/include/__data_card.blade.php ENDPATH**/ ?>